<?php

namespace App\Modules\AdminSession\Application\Index;

use App\Modules\AdminSession\Application\Index\AdminSessionGetterResponse;
use App\Modules\AdminSession\Domain\AdminSessionRepository;

final class AdminSessionGetter
{
    public function __construct(private AdminSessionRepository $repository)
    {
    }

    public function __invoke(string $token): AdminSessionGetterResponse
    {
        return new AdminSessionGetterResponse($this->repository->current($token));
    }
}
