<?php

namespace App\Modules\Admin\Application\Delete;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class AdminDeleterQueryHandler implements QueryHandler
{
    public function __construct(private AdminDeleter $inserter)
    {
    }

    public function __invoke(AdminDeleterQuery $query): AdminDeleterResponse
    {
        return $this->inserter->__invoke(new IdAdmin($query->getId()));
    }
}
