<?php

namespace App\Modules\Admin\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class AdminInserterQuery implements Query
{
    public function __construct(
        private string $name,
        private string $lastName,
        private string $abrv,
        private string $noDocument,
        private string $email,
        private string $emailAddress,
        private string $address,
        private string $phone,
        private string $color,
        private int $isAssignable,
        private string $imgProfile,
        private string $imgProfileThumb,
        private int $status,
        private int $idTypeDocument,
        private int $idAdminRole,
        private int $idCountry,
        private int $idState,
        private int $idCity,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function lastName(): string
    {
        return $this->lastName;
    }

    public function abrv(): string
    {
        return $this->abrv;
    }

    public function noDocument(): string
    {
        return $this->noDocument;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function emailAddress(): string
    {
        return $this->emailAddress;
    }

    public function address(): string
    {
        return $this->address;
    }

    public function phone(): string
    {
        return $this->phone;
    }

    public function color(): string
    {
        return $this->color;
    }

    public function isAssignable(): int
    {
        return $this->isAssignable;
    }

    public function imgProfile(): string
    {
        return $this->imgProfile;
    }

    public function imgProfileThumb(): string
    {
        return $this->imgProfileThumb;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idTypeDocument(): int
    {
        return $this->idTypeDocument;
    }

    public function idAdminRole(): int
    {
        return $this->idAdminRole;
    }

    public function idCountry(): int
    {
        return $this->idCountry;
    }

    public function idState(): int
    {
        return $this->idState;
    }

    public function idCity(): int
    {
        return $this->idCity;
    }
}
