<?php

namespace App\Modules\Admin\Application\Create;

use App\Modules\Admin\Application\Create\AdminInserterResponse;
use App\Modules\Admin\Domain\AdminRepository;
use App\Modules\Admin\Domain\InsertAdmin;

final class AdminInserter
{
    public function __construct(private AdminRepository $repository)
    {
    }

    public function __invoke(InsertAdmin $admin): AdminInserterResponse
    {
        return new AdminInserterResponse($this->repository->insert($admin));
    }
}
