<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Factory as Auth;

use App\Http\Controllers\Owner\c_Admin_Session;
use App\Http\Helpers\ResponseBuilder;

class Authenticate_Owner_Url
{

    protected $auth;

    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }

    public function handle($Request, Closure $next, $guard = null)
    {
        if ($Request->input('Token') == '') {
            $oResponse["Response_Status"]           = 401;
            $oResponse["Response_Code"]             = 401;
            $oResponse["Response_Domain"]           = "Global";
            $oResponse["Response_Message"]          = "Missing request header 'authorization' for method parameter of type String";
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = "Bad Request";
            $oResponse["Response_Error_Reason"]     = "Missing request header 'authorization' for method parameter of type String";

            return ResponseBuilder::Response($oResponse);
        } else {
            $oData  = c_Admin_Session::UpdateElement($Request->input('Token'), '', $Request->ip());

            if ($oData[0]->Response_Success == true) {
                return $next($Request);
            } else {
                $oResponse["Response_Status"]           = $oData[0]->Response_Status;
                $oResponse["Response_Code"]             = $oData[0]->Response_Code;
                $oResponse["Response_Domain"]           = "Global";
                $oResponse["Response_Message"]          = $oData[0]->Response_Message;
                $oResponse["Response_Data"]             = null;
                $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
                $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;

                return ResponseBuilder::Response($oResponse);
            }
        }
    }
}
