<?php

namespace App\Http\Controllers\Passenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class c_Passenger_Session extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Passsenger Session";
    }

    public function Insert(Request $Request)
    {

        $oResponse  = array();
        $oValParams = array(
            'Pax_NoDocument'    => 'required|string|max:20',
            'Booking_Code'      => 'required|string|max:250'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                Str::upper($Request->input("Booking_Code")),
                $Request->input("Pax_NoDocument")
            );

            $oData = DB::select('call sp_passenger_passenger_login(?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $Response_Data  = array(
                    "Token"             => $oData[0]->Response_Token,
                    "Id_Passsenger"     => $oData[0]->Response_Id
                );
            } else {
                $Response_Data  = null;
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $Response_Data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public static function Update(Request $Request)
    {
        if ($Request->header("Token") != "" && $Request->header("Id") != "") {
            $oParam     = array($Request->header("Token"), $Request->header("Id"));
            $oData      = DB::select('call sp_passenger_passenger_update(?,?)', $oParam);

            return $oData;
        }
    }
}
