<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Package_Rate extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Package Rate";
        $this->history = new HistoryData(HistoryTables::PACKAGE_RATE);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'PackageRate_PaxStart'          => 'required|int|min:1',
            'PackageRate_PaxEnd'            => 'required|int|min:1',
            'PackageRate_Price'             => 'required|numeric',
            'PackageRate_PriceConfidential' => 'required|numeric',
            'PackageRate_Type'              => 'required|numeric',
            'PackageRate_Status'            => 'required|int',
            'Id_Package'                    => 'required|int',
            'Id_TypeRate'                   => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                $Request->input("PackageRate_PaxStart"),
                $Request->input("PackageRate_PaxEnd"),
                $Request->input("PackageRate_Price"),
                $Request->input("PackageRate_PriceConfidential"),
                $Request->input("PackageRate_Type"),
                $Request->input("PackageRate_Status"),
                $Request->input("Id_Package"),
                $Request->input("Id_TypeRate")
            );
            $oData = DB::select('call sp_package_rate_insert(?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->insertBasic($Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_PackageRate'                => 'required|int',
            'PackageRate_PaxStart'          => 'required|int|min:1',
            'PackageRate_PaxEnd'            => 'required|int|min:1',
            'PackageRate_Price'             => 'required|numeric',
            'PackageRate_PriceConfidential' => 'required|numeric',
            'PackageRate_Type'              => 'required|numeric',
            'PackageRate_Status'            => 'required|int',
            'Id_Package'                    => 'required|int',
            'Id_TypeRate'                   => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            //region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_PackageRate'));
            //endregion

            $oParam = array(
                $Request->input("Id_PackageRate"),
                $Request->input("PackageRate_PaxStart"),
                $Request->input("PackageRate_PaxEnd"),
                $Request->input("PackageRate_Price"),
                $Request->input("PackageRate_PriceConfidential"),
                $Request->input("PackageRate_Type"),
                $Request->input("PackageRate_Status"),
                $Request->input("Id_Package"),
                $Request->input("Id_TypeRate")
            );
            $oData = DB::select('call sp_package_rate_update(?,?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_PackageRate"), $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            //region HISTORY
            $this->history->obtainOld($Id);
            //endregion

            $oParam = array($Id);
            $oData  = DB::select('call sp_package_rate_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_package_rate_index(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id_Package, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Package, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

            if ($oResponse["Response_Code"] == 200) {
                $oParam = array($Id, $Id_Package);
                $oData  = DB::select('call sp_package_rate_list(?,?)', $oParam);

                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }
        return ResponseBuilder::Response($oResponse);
    }
}
