<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

class c_Invoice_Fee_Detail extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Invoice Fee Detail";
	}

	
	public function List(Request $Request, $Id_InvoiceFee){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_InvoiceFee,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_InvoiceFee );
			$oData  = DB::select('call sp_invoice_fee_detail_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);	
	}

	
}