<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Flight_Passenger extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;
    /** @var HistoryData */
    private $historyGroupPassenger;

    public function __construct()
    {
        $this->oDomain = "Flight Passenger";
        $this->history = new HistoryData(HistoryTables::FLIGHT_PASSENGER);
        $this->historyGroupPassenger = new HistoryData(HistoryTables::GROUP_PASSENGER);
    }

    public static function findBooking($Id_FlightPassenger)
    {
        $found = DB::select('CALL `sp_flight_passenger_index`(?)', [$Id_FlightPassenger]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function Insert_All(Request $Request)
    {
        $oSucces    = true;
        $oResponse  = array();
        $oValParams = array(
            'Id_Flight'        => 'required|int',
            'Passenger'        => 'required|string'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $Id_Booking = c_Flight::findBooking($Request->input('Id_Flight'));

            $oPassenger = json_decode($Request->input("Passenger"));


            $oParam     = array($Request->input("Id_Flight"));
            $oData      = DB::select('call sp_flight_group_index(?)', $oParam);
            $Id_Group   = $oData[0]->Id_Group;


            for ($k = 0; $k < count($oPassenger); $k++) {
                //region AGREGA PASAJERO AL VUELO
                $oParam = array(
                    $Request->input("Id_Flight"),
                    $oPassenger[$k]->Id_Passenger
                );
                $oData = DB::select('call sp_flight_passenger_insert(?,?)', $oParam);
                //endregion

                if ($oData[0]->Response_Success == 0) {
                    $oSucces = false;
                    break;
                }

                $this->history->insert(
                    [
                        'Id_Flight' => $Request->input('Id_Flight'),
                        'Id_Passenger' => $Request->input('Id_Passenger')
                    ],
                    $Request,
                    $Id_Booking
                );

                //region AGREGA PASAJERO AL GRUPO
                $oParam = array(
                    2,
                    $Id_Group,
                    $oPassenger[$k]->Id_Passenger
                );
                $oData = DB::select('call sp_group_passenger_insert(?,?,?)', $oParam);
                //endregion

                if ($oData[0]->Response_Success == 0) {
                    $oSucces = false;
                    break;
                }

                $this->historyGroupPassenger->insert(
                    [
                        'GroupPassenger_Type' => 2,
                        'Id_Group' => $Id_Group,
                        'Id_Passenger' => $oPassenger[$k]->Id_Passenger
                    ],
                    $Request,
                    $Id_Group
                );
            }

            if ($oSucces == true) {
                $oData = array(
                    array(
                        "Response_Status"     => 200,
                        "Response_Code"     => 200,
                        "Response_Message"     => "Pasajeros guardados con éxito",
                        "Response_Reason"     => null
                    )
                );

                $oData = json_decode(json_encode($oData));
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_Flight'            => 'required|int',
            'Id_Passenger'        => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                $Request->input("Id_Flight"),
                $Request->input("Id_Passenger")
            );
            $oData = DB::select('call sp_flight_passenger_insert(?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {

                $this->history->insert(
                    [
                        'Id_Flight' => $Request->input('Id_Flight'),
                        'Id_Passenger' => $Request->input('Id_Passenger')
                    ],
                    $Request,
                    c_Flight::findBooking($Request->input('Id_Flight'))
                );

                $oParam     = array($Request->input("Id_Flight"));
                $oData         = DB::select('call sp_flight_group_index(?)', $oParam);
                $Id_Group    = $oData[0]->Id_Group;

                //region AGREGA PASAJERO AL GRUPO
                $oParam = array(
                    2,
                    $Id_Group,
                    $Request->input('Id_Passenger')
                );
                $oData = DB::select('call sp_group_passenger_insert(?,?,?)', $oParam);
                //endregion

                $this->historyGroupPassenger->insert(
                    [
                        'GroupPassenger_Type' => 2,
                        'Id_Group' => $Id_Group,
                        'Id_Passenger' => $Request->input('Id_Passenger')
                    ],
                    $Request,
                    $Id_Group
                );
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_FlightPassenger'    => 'required|int',
            'Id_Flight'            => 'required|int',
            'Id_Passenger'        => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input("Id_FlightPassenger"));

            $oParam = array(
                $Request->input("Id_FlightPassenger"),
                $Request->input("Id_Flight"),
                $Request->input("Id_Passenger")
            );
            $oData = DB::select('call sp_flight_passenger_update(?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    c_Flight::findBooking($Request->input("Id_Flight")),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld();
            $oParam = array($Id);
            $oData     = DB::select('call sp_flight_passenger_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->delete(
                    $this->findBooking($Id),
                    $this->history->oldValue,
                    $Request
                );
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData     = DB::select('call sp_flight_passenger_index(?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " Index";
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id_Flight)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Flight, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id_Flight);
            $oData  = DB::select('call sp_flight_passenger_list(?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " list " . $Id_Flight;
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
