<?php

namespace App\Http\Controllers\Owner\WebContactMessageDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessageDetail\Application\Update\UpdateWebContactMessageDetailQuery;
use App\Modules\WebContactMessageDetail\Application\Update\UpdateWebContactMessageDetailQueryResponse;
use App\Modules\WebContactMessageDetail\Infraestructure\WebContactMessageDetailValidators;

class WebContactMessageDetailUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessageDetail";
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageDetailValidators::UPDATE);

        /** @var UpdateWebContactMessageDetailQueryResponse $response */
        $response = $this->queryBus->ask(new UpdateWebContactMessageDetailQuery(
            $request->input('Id_WebContactMessageDetail'),
            $request->input('WebContactMessageDetail_DateStart'),
            $request->input('WebContactMessageDetail_Package'),
            $request->input('WebContactMessageDetail_Status'),
            $request->input('Id_WebContactMessage'),
        ));

        $this->history->updateBasic($request->input("Id_WebContactMessageDetail"), $request);

        return ResponseBuilder::Response($response->response());
    }
}
