<?php

namespace App\Http\Controllers\Owner\WebContactMessageDetail;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContactMessageDetail\Application\Index\IndexWebContactMessageDetailQuery;
use App\Modules\WebContactMessageDetail\Application\Index\IndexWebContactMessageDetailQueryResponse;

class WebContactMessageDetailIndexController extends Controller
{
    private $domain = 'WebContactMessageDetail';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexWebContactMessageDetailQueryResponse $response */
        $response = $this->queryBus->ask(new IndexWebContactMessageDetailQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
