<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessage\Application\List\ListWebContactMessageQueryResponse;
use App\Modules\WebContactMessage\Application\ListAll\ListAllWebContactMessageQuery;
use App\Modules\WebContactMessage\Infraestructure\WebContactMessageValidators;

class WebContactMessageListAllController extends Controller
{
    private $domain = 'WebContactMessage';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action, Request $Request)
    {
        (new LaravelValidator())->validate($Request->all(), $this->domain, WebContactMessageValidators::LIST_ALL);

        /** @var ListWebContactMessageQueryResponse $response */
        $response = $this->queryBus->ask(new ListAllWebContactMessageQuery(
            $Request->input('DateStart'),
            $Request->input('DateEnd'),
            $Action
        ));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
