<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContactMessage\Application\Index\IndexWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\Index\IndexWebContactMessageQueryResponse;

class WebContactMessageIndexController extends Controller
{
    private $domain = 'WebContactMessage';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexWebContactMessageQueryResponse $response */
        $response = $this->queryBus->ask(new IndexWebContactMessageQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
