<?php

namespace App\Http\Controllers\Owner\TypeBookingAssign;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\TypeBookingAssign\Application\Index\IndexTypeBookingAssignQuery;
use App\Modules\TypeBookingAssign\Application\Index\IndexTypeBookingAssignQueryResponse;

class TypeBookingAssignIndexController extends Controller
{
    private $domain = 'TypeBookingAssign';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexTypeBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new IndexTypeBookingAssignQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
