<?php

namespace App\Http\Controllers\Owner\Tour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Tour\Application\TourQuestionCopier;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\Tour\Infraestructure\MysqlTourCopyQuestionsRepository;
use App\Modules\Tour\Infraestructure\TourCopyQuestionsValidators;

final class CopyQuestions extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'Tour';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, TourCopyQuestionsValidators::BASIC);
        $response = (new TourQuestionCopier(new MysqlTourCopyQuestionsRepository))
            ->__invoke(
                new IdTour($request->input('TourFrom')),
                new IdTour($request->input('TourTo'))
            );
        return ResponseBuilder::Response($response);
    }
}
