<?php

namespace App\Http\Controllers\Owner\StatusGroupProvider;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroupProvider\Application\Index\IndexStatusGroupProviderQuery;
use App\Modules\StatusGroupProvider\Application\Index\IndexStatusGroupProviderQueryResponse;

class StatusGroupProviderIndexController extends Controller
{
    private $domain = 'StatusGroupProvider';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexStatusGroupProviderQueryResponse $response */
        $response = $this->queryBus->ask(new IndexStatusGroupProviderQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
