<?php

namespace App\Http\Controllers\Owner\StatusGroupProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroupProvider\Application\Delete\DeleteStatusGroupProviderQuery;
use App\Modules\StatusGroupProvider\Application\Delete\DeleteStatusGroupProviderQueryResponse;

class StatusGroupProviderDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::STATUS_GROUP_PROVIDER);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteStatusGroupProviderQueryResponse $response */
        $response = $this->queryBus->ask(new DeleteStatusGroupProviderQuery($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
