<?php

namespace App\Http\Controllers\Owner\Report\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Report\Booking\Application\BySellerMonthly\ReportBySellerMonthlyBookingQuery;
use App\Modules\Report\Booking\Application\BySellerMonthly\ReportBySellerMonthlyBookingResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class ReportBookingBySellerMonthlyController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "ReportBooking";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, [
            'DateStart' => 'required|string|date',
            'DateEnd' => 'required|string|date',
        ]);
        // $this->transaction->begin();

        /** @var ReportBySellerMonthlyBookingResponse $response */
        $response = $this->queryBus->ask(new ReportBySellerMonthlyBookingQuery(
            $request->input('DateStart'),
            $request->input('DateEnd')
        ));

        // $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reporte generado correctamente',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
