<?php
namespace App\Http\Controllers\Owner\QuestionTypeProvider;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\QuestionTypeProvider\Application\Index\QuestionTypeProviderIndexerQuery;
use App\Modules\QuestionTypeProvider\Application\Index\QuestionTypeProviderIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class QuestionTypeProviderIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var QuestionTypeProviderIndexerResponse $response */
        $response = $this->queryBus->ask(new QuestionTypeProviderIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
