<?php

namespace App\Http\Controllers\Owner\ProviderTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ProviderTypeProvider\Application\Delete\ProviderTypeProviderDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderTypeProviderDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::PROVIDER_TYPE_PROVIDER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var ProviderTypeProviderDeleterResponse $response */
        $response = $this->queryBus->ask(new ProviderTypeProviderDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
