<?php

namespace App\Http\Controllers\Owner\ProviderSanction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ProviderSanction\Application\Update\ProviderSanctionUpdaterQuery;
use App\Modules\ProviderSanction\Application\Update\ProviderSanctionUpdaterResponse;
use App\Modules\ProviderSanction\Infraestructure\ProviderSanctionValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderSanctionUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ProviderSanction";
        $this->history = new HistoryData(HistoryTables::PROVIDER_SANCTION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ProviderSanctionValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_ProviderSanction"));

        /** @var ProviderSanctionUpdaterResponse $response */
        $response = $this->queryBus->ask(new ProviderSanctionUpdaterQuery(
            $request->input('Id_ProviderSanction'),
            $request->input('ProviderSanction_Remark'),
            $request->input('ProviderSanction_DateStart'),
            $request->input('ProviderSanction_DateEnd'),
            $request->input('ProviderSanction_Status'),
            $request->input('Id_Provider')
        ));

        $this->history->updateBasic($request->input("Id_ProviderSanction"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
