<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Passenger\Application\UpdateReportable\UpdatePassengerReportableQuery;
use App\Modules\Passenger\Application\UpdateReportable\UpdatePassengerReportableResponse;
use App\Modules\Passenger\Infraestructure\PassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class PassengerReportablePutController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Passenger";
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, PassengerValidators::UPDATE_REPORTABLE);

        $this->history->obtainOld($request->input("Id_Passenger"));

        /** @var UpdatePassengerReportableResponse $response */
        $response = $this->queryBus->ask(
            new UpdatePassengerReportableQuery(
                $request->input('Id_Passenger'),
                $request->input('Passenger_Reportable'),
            )
        );

        $this->history->updateBasic($request->input("Id_Passenger"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
