<?php
namespace App\Http\Controllers\Owner\LeadBookingServicePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingServicePassenger\Application\List\LeadBookingServicePassengerListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServicePassengerListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_LeadBookingService, $Action)
    {
        /** @var LeadBookingServicePassengerListerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServicePassengerListerQuery($Id_LeadBookingService, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
