<?php
namespace App\Http\Controllers\Owner\HtlTypeRoom;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlTypeRoom\Application\Delete\DeleteHtlTypeRoomQuery;
use App\Modules\HtlTypeRoom\Application\Delete\DeleteHtlTypeRoomResponse;
use App\Modules\HtlTypeRoom\Application\Delete\HtlTypeRoomDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomDeleteController extends Controller
{
    private $domain = "HtlTypeRoom";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        $this->transaction->begin();
        /** @var DeleteHtlTypeRoomResponse $response */
        $response = $this->queryBus->ask(new DeleteHtlTypeRoomQuery($Id));

        $this->transaction->commit();
        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación eliminado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
