<?php

namespace App\Http\Controllers\Owner\HtlTypeCamp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlTypeCamp\Application\Update\UpdateHtlTypeCampQuery;
use App\Modules\HtlTypeCamp\Infrastructure\HtlTypeCampValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeCampUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeCamp";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_CAMP);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlTypeCampValidators::UPDATE);
        $this->transaction->begin();
        $this->history->obtainOld($request->input('Id_HtlTypeCamp'));
        $this->queryBus->ask(new UpdateHtlTypeCampQuery(
            $request->input('Id_HtlTypeCamp'),
            $request->input('HtlTypeCamp_Name'),
            $request->input('HtlTypeCamp_Abrv'),
            $request->input('HtlTypeCamp_Status'),
        ));
        $this->history->updateBasic($request->input('Id_HtlTypeCamp'), $request);
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Campamento modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
