<?php
namespace App\Http\Controllers\Owner\HtlTypeCamp;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlTypeCamp\Application\HtlTypeCampResponses;
use App\Modules\HtlTypeCamp\Application\List\HtlTypeCampListerQuery;
use App\Modules\HtlTypeCamp\Application\List\ListHtlTypeCampQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeCampListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeCamp";
    }

    public function __invoke($Action)
    {
        $this->transaction->begin();
        /** @var HtlTypeCampResponses $response */
        $response = $this->queryBus->ask(new ListHtlTypeCampQuery($Action));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Campamento agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
