<?php
namespace App\Http\Controllers\Owner\HtlCampBooking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCampBooking\Application\Delete\DeleteHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\Delete\DeleteHtlCampBookingResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingDeleteController extends Controller
{
    private $domain = "HtlCampBooking";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_CAMP_BOOKING);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        $this->transaction->begin();
        /** @var DeleteHtlCampBookingResponse $response */
        $response = $this->queryBus->ask(new DeleteHtlCampBookingQuery($Id));
        $this->transaction->commit();

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reserva de campamento eliminada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
