<?php
namespace App\Http\Controllers\Owner\HtlBed;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlBed\Application\Delete\DeleteHtlBedQuery;
use App\Modules\HtlBed\Application\Delete\DeleteHtlBedResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlBedDeleteController extends Controller
{
    private $domain = "HtlBed";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_BED);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->transaction->begin();
        $this->history->obtainOld($Id);
        /** @var DeleteHtlBedResponse $response */
        $response = $this->queryBus->ask(new DeleteHtlBedQuery($Id));

        $this->history->deleteBasic($Id, $request);
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Cama eliminada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
