<?php

namespace App\Http\Controllers\Owner\History;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\History\Application\HistoryResponses;
use App\Modules\History\Application\List\ListHistoryQuery;
use App\Modules\History\Application\ListCount\ListCountHistoryQuery;
use App\Modules\History\Application\ListCount\ListCountHistoryResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use Illuminate\Http\Request;

class HistoryListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "History";
    }

    public function __invoke(Request $request, $Action)
    {
        $this->transaction->begin();
        /** @var HistoryResponses $response */
        $response = $this->queryBus->ask(new ListHistoryQuery(
            $request->input('Date_Start'),
            $request->input('Date_End'),
            $request->input('Id_HistoryTable'),
            0,
            $Action,
            $request->input('Page', null),
            $request->input('PageSize', null)
        ));
        /** @var ListCountHistoryResponse $responseCount */
        $responseCount = $this->queryBus->ask(new ListCountHistoryQuery(
            $request->input('Date_Start'),
            $request->input('Date_End'),
            $request->input('Id_HistoryTable'),
            0,
            $Action,
        ));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            'Response_Count'            => $responseCount->count(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
