<?php
namespace App\Http\Controllers\Owner\FactUnit;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactUnit\Application\FactUnitResponse;
use App\Modules\FactUnit\Application\Index\FactUnitIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactUnitIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactUnitResponse $response */
        $response = $this->queryBus->ask(new FactUnitIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
