<?php

namespace App\Http\Controllers\Owner\FactTypeOperation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactTypeOperation\Application\Update\FactTypeOperationUpdaterQuery;
use App\Modules\FactTypeOperation\Application\Update\FactTypeOperationUpdaterResponse;
use App\Modules\FactTypeOperation\Infraestructure\FactTypeOperationValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeOperationUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactTypeOperation";
        $this->history = new HistoryData(HistoryTables::FACT_TYPE_OPERATION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactTypeOperationValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactTypeOperation"));

        /** @var FactTypeOperationUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactTypeOperationUpdaterQuery(
            $request->input('Id_FactTypeOperation'),
            $request->input('FactTypeOperation_Name'),
            $request->input('FactTypeOperation_Abrv'),
            $request->input('FactTypeOperation_Status'),
        ));

        $this->history->updateBasic($request->input("Id_FactTypeOperation"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
