<?php
namespace App\Http\Controllers\Owner\FactTypeOperation;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeOperation\Application\FactTypeOperationResponse;
use App\Modules\FactTypeOperation\Application\Index\FactTypeOperationIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeOperationIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactTypeOperationResponse $response */
        $response = $this->queryBus->ask(new FactTypeOperationIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
