<?php

namespace App\Http\Controllers\Owner\FactTypeDocument;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactTypeDocument\Application\Update\FactTypeDocumentUpdaterQuery;
use App\Modules\FactTypeDocument\Application\Update\FactTypeDocumentUpdaterResponse;
use App\Modules\FactTypeDocument\Infraestructure\FactTypeDocumentValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeDocumentUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactTypeDocument";
        $this->history = new HistoryData(HistoryTables::FACT_TYPE_DOCUMENT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactTypeDocumentValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactTypeDocument"));

        /** @var FactTypeDocumentUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactTypeDocumentUpdaterQuery(
            $request->input('Id_FactTypeDocument'),
            $request->input('FactTypeDocument_Name'),
            $request->input('FactTypeDocument_Abrv'),
            $request->input('FactTypeDocument_Status'),
        ));

        $this->history->updateBasic($request->input("Id_FactTypeDocument"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
