<?php

namespace App\Http\Controllers\Owner\FactReceiptDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactReceiptDetail\Application\Delete\DeleteFactReceiptDetailQuery;
use App\Modules\FactReceiptDetail\Application\Delete\DeleteFactReceiptDetailResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactReceiptDetail\Application\Update\FactReceiptDetailUpdaterQuery;
use App\Modules\FactReceiptDetail\Application\Update\FactReceiptDetailUpdaterResponse;
use App\Modules\FactReceiptDetail\Infraestructure\FactReceiptDetailValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptDetailDeleteController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactReceiptDetail";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT_DETAIL);
    }

    public function __invoke(Request $request, $Id)
    {

        $this->history->obtainOld($Id);

        /** @var DeleteFactReceiptDetailResponse $response */
        $response = $this->queryBus->ask(new DeleteFactReceiptDetailQuery($Id));

        $this->history->deleteBasic($request->input("Id_FactReceiptDetail"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
