<?php

namespace App\Http\Controllers\Owner\FactProduct;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactProduct\Application\FactProductResponses;
use App\Modules\FactProduct\Application\List\FactProductListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactProductListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactProductResponses $response */
        $response = $this->queryBus->ask(new FactProductListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
