<?php

namespace App\Http\Controllers\Owner\FactCurrency;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactCurrency\Application\Create\CreateFactCurrencyQuery;
use App\Modules\FactCurrency\Application\Create\CreateFactCurrencyResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactCurrency\Infrastructure\FactCurrencyValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactCurrencyInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "FactCurrency";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactCurrencyValidators::INSERT);
        $this->transaction->begin();
        /** @var CreateFactCurrencyResponse $response */
        $response = $this->queryBus->ask(new CreateFactCurrencyQuery(
            $request->input('FactCurrency_Name'),
            $request->input('FactCurrency_Abrv'),
            $request->input('FactCurrency_Status'),
        ));
        $this->transaction->commit();
        $this->history->insertBasic($request, $response->id());
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => ['id' => $response->id()],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Moneda de Facturación agregada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
