<?php
namespace App\Http\Controllers\Owner\ExternalUser;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUser\Application\ExternalUserDeleter;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUser\Infraestructure\MysqlExternalUserRepository;

class ExternalUserDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::EXTERNAL_USER);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new ExternalUserDeleter(new MysqlExternalUserRepository()))
            ->__invoke(new IdExternalUser($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
