<?php

namespace App\Http\Controllers\Owner\CalendarTour;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\CalendarTour\Application\ListPassengerAlter\ListPassengerAlterCalendarTourQuery;
use App\Modules\CalendarTour\Application\ListPassengerAlter\ListPassengerAlterCalendarTourResponse;
use App\Modules\CalendarTour\Infrastructure\Validators\CalendarTourValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class CalendarTourPassengerController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Booking Calendar";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, CalendarTourValidators::LIST_PASSENGER);

        /** @var ListPassengerAlterCalendarTourResponse $response */
        $response = $this->queryBus->ask(new ListPassengerAlterCalendarTourQuery(
            $request->get('Id_Tour'),
            $request->get('DateStart'),
        ));
        return ResponseBuilder::Response($response->response());
    }
}
