<?php

namespace App\Http\Controllers\Owner\Calendar;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\BookingCalendar\Application\List\ListBookingCalendarResponse;
use App\Modules\BookingCalendar\Application\ListPassenger\ListPassengerBookingCalendarQuery;
use App\Modules\BookingCalendar\Infrastructure\Validators\BookingCalendarValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingCalendarPassengerController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Booking Calendar";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, BookingCalendarValidators::LIST_PASSENGER);

        /** @var ListBookingCalendarResponse $response */
        $response = $this->queryBus->ask(new ListPassengerBookingCalendarQuery(
            $request->get('Id_Tour'),
            $request->get('DateStart'),
        ));
        return ResponseBuilder::Response($response->response());
    }
}
