<?php

namespace App\Http\Controllers\Owner\BookingUpgradePassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingUpgradePassenger\Infrastructure\BookingUpgradePassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class BookingUpgradePassengerMassiveUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingUpgradePassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_UPGRADE_PASSENGER);
    }

    public static function findBooking($Id_BookingUpgradePassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingUpgradePassenger, 1]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingUpgradePassengerValidators::MASSIVE_UPDATE);

        foreach ($request->input('BookingUpgradePassenger') as $bep) {
            $response = $this->saveBookingUpgradePassenger($bep, $request);
            if ($response['Response_Status'] !== 200) {
                ResponseBuilder::Response($response);
            }
        }

        return ResponseBuilder::Response($response);
    }

    private function saveBookingUpgradePassenger($idBookingUpgradePassenger, $request)
    {

        $this->history->obtainOld($idBookingUpgradePassenger);

        $oParam = array(
            $request->input('BookingUpgradePassenger_OnlyReturn'),
            $request->input('BookingUpgradePassenger_DateEntry') . ':00',
            $request->input('BookingUpgradePassenger_Datereturn') . ':00',
            $request->input('BookingUpgradePassenger_DatePurchase'),
            $request->input('BookingUpgradePassenger_Carrier'),
            $request->input('BookingUpgradePassenger_Code'),
            $request->input('BookingUpgradePassenger_Amount'),
            $request->input('BookingUpgradePassenger_RoundCarrier'),
            $request->input('BookingUpgradePassenger_RoundCode'),
            $request->input('BookingUpgradePassenger_RoundAmount'),
            $request->input('BookingUpgradePassenger_Remark'),
            $request->header('Token'),
            $request->input('Id_Provider', 0),
            $request->input('Id_Provider_Return', 0),
            $idBookingUpgradePassenger
        );
        $oData = DB::select('call sp_booking_upgrade_passenger_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);

        if ($oData[0]->Response_Success == 1) {
            $this->history->update(
                $this->findBooking($request->input("Id_BookingUpgradePassenger")),
                $this->history->oldValue,
                [$request->all()],
                $request
            );
        }

        return [
            'Response_Status'           => $oData[0]->Response_Status,
            'Response_Code'             => $oData[0]->Response_Code,
            'Response_Domain'           => $this->domain,
            'Response_Message'          => $oData[0]->Response_Message,
            'Response_Data'             => null,
            'Response_Error_Message'    => $oData[0]->Response_Message,
            'Response_Error_Reason'     => $oData[0]->Response_Reason,
        ];
    }
}
