<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class BookingUpgradeExtraEquipment extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Booking Upgrade - Extra - Equipment";
    }

    public function List(Request $Request, $Id_BookingTour)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_BookingTour, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {

            $oData  = array_merge(
                array_map(
                    function ($upgrade) {
                        $upgrade->id = $upgrade->Id_BookingUpgrade;
                        $upgrade->cant = $upgrade->BookingUpgrade_Quantity;
                        $upgrade->price = $upgrade->BookingUpgrade_Price;
                        $upgrade->total = $upgrade->BookingUpgrade_Total;
                        $upgrade->included = $upgrade->BookingUpgrade_Included;
                        $upgrade->name = $upgrade->Upgrade_Name;
                        $upgrade->type = 1;
                        return $upgrade;
                    },
                    DB::select('call sp_booking_upgrade_list(?)', [$Id_BookingTour]),
                ),
                array_map(
                    function ($extra) {

                        $extra->id = $extra->Id_BookingExtra;
                        $extra->cant = $extra->BookingExtra_Quantity;
                        $extra->price = $extra->BookingExtra_Price;
                        $extra->total = $extra->BookingExtra_Total;
                        $extra->included = $extra->BookingExtra_Included;
                        $extra->name = $extra->Extra_Name;
                        $extra->type = 2;
                        return $extra;
                    },
                    DB::select('call sp_booking_extra_list(?)', [$Id_BookingTour]),
                ),
                array_map(
                    function ($equipment) {

                        $equipment->id = $equipment->Id_BookingEquipment;
                        $equipment->cant = $equipment->BookingEquipment_Quantity;
                        $equipment->price = $equipment->BookingEquipment_Price;
                        $equipment->total = $equipment->BookingEquipment_Total;
                        $equipment->included = $equipment->BookingEquipment_Included;
                        $equipment->name = $equipment->Item_Name;
                        $equipment->type = 3;
                        return $equipment;
                    },
                    DB::select('call sp_booking_equipment_list(?)', [$Id_BookingTour]),
                ),
            );

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id_BookingTour;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public static function generateMore(
        $generateMore,
        $index,
        $InvoiceDetail_Description,
        $InvoiceDetail_Price
    ) {
        if ($generateMore == 2 && count($index)) {
            $invoice = DB::select(
                'CALL `sp_invoice_index_by_passenger`(?)',
                [$index[0]->Id_Passenger]
            )[0];

            DB::select(
                'CALL `sp_invoice_detail_insert`(?,?,?,?,?,?,?,?,?,?,?,?)',
                [
                    1,
                    $InvoiceDetail_Description,
                    $InvoiceDetail_Price,
                    $InvoiceDetail_Price,
                    1,
                    4,
                    100,
                    1,
                    0,
                    $invoice->Id_Invoice,
                    0,
                    1,
                ]
            );
        }
        DB::select('CALL `sp_invoice_reload`(?,?)', [$index[0]->Id_Passenger, 1]);
    }
}
