<?php

namespace App\Http\Controllers\Owner\BookingAssign;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Owner\Admin;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\BookingAssign\Application\List\ListBookingAssignQuery;
use App\Modules\BookingAssign\Application\List\ListBookingAssignQueryResponse;

class BookingAssignListController extends Controller
{
    private $domain = 'BookingAssign';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_Booking, $Action, Request $Request)
    {
        /** @var ListBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new ListBookingAssignQuery($Id_Booking, $Action));
        $data = array_map([Admin::class, 'appendPath'], $response->response());
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($data, '', $this->domain));
    }
}
