<?php

namespace App\Http\Controllers\Owner\BookingAssign;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\BookingAssign\Application\Index\IndexBookingAssignQuery;
use App\Modules\BookingAssign\Application\Index\IndexBookingAssignQueryResponse;

class BookingAssignIndexController extends Controller
{
    private $domain = 'BookingAssign';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new IndexBookingAssignQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
