<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use Illuminate\Support\Facades\DB;

class c_Type_Payment extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Type Payment";
	}

	public function Index(Request $Request, $Id)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array($Id);
			$oData 	= DB::select('call sp_type_payment_index(?)', $oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function List(Request $Request, $Id)
	{
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = [
				$Id,
				config('var.PATH_PUBLIC')
			];
			$oData  = DB::select('call sp_type_payment_list(?,?)', $oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " list " . $Id;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Selector(Request $Request, $Id)
	{
		if (is_numeric($Id)) {
			return SELF::Index($Request, $Id);
		} else {
			return SELF::List($Request, $Id);
		}
	}
}
