<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_Invoice_Fee_Detail extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Invoice Fee Detail";
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'InvoiceFeeDetail_Amount'           => 'required|numeric',
			'InvoiceFeeDetail_Name'             => 'required|string|max:250',
			'InvoiceFeeDetail_LastName'         => 'required|string|max:250',
			'InvoiceFeeDetail_Email'            => 'required|string|max:250',
			'InvoiceFeeDetail_Country'          => 'required|string|max:250',
			'InvoiceFeeDetail_City'             => 'required|string|max:250',
			'InvoiceFeeDetail_Address'          => 'required|string|max:250',
			'InvoiceFeeDetail_Phone'            => 'required|string|max:250',
			'InvoiceFeeDetail_ReceiptNumber'    => 'required|string|max:250',
			'InvoiceFeeDetail_CardLast'         => 'required|string|max:250',
			'InvoiceFeeDetail_CardNumber'       => 'required|string|max:250',
			'InvoiceFeeDetail_CardBrand'        => 'required|string|max:250',
			'InvoiceFeeDetail_CardType'         => 'required|string|max:250',
			'InvoiceFeeDetail_CardIssuer'       => 'required|string|max:250',
			'Id_InvoiceFee'                     => 'required|int'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(
				$Request->input("InvoiceFeeDetail_Amount"),
				$Request->input("InvoiceFeeDetail_Name"),
				$Request->input("InvoiceFeeDetail_LastName"),
				$Request->input("InvoiceFeeDetail_Email"),
				$Request->input("InvoiceFeeDetail_Country"),
				$Request->input("InvoiceFeeDetail_City"),
				$Request->input("InvoiceFeeDetail_Address"),
				$Request->input("InvoiceFeeDetail_Phone"),
				$Request->input("InvoiceFeeDetail_ReceiptNumber"),
				$Request->input("InvoiceFeeDetail_CardLast"),
				$Request->input("InvoiceFeeDetail_CardNumber"),
				$Request->input("InvoiceFeeDetail_CardBrand"),
				$Request->input("InvoiceFeeDetail_CardType"),
				$Request->input("InvoiceFeeDetail_CardIssuer"),
				$Request->input("Id_InvoiceFee")
			);
			$oData = DB::select('call sp_invoice_fee_detail_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
}
