<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class UserCountryMother
{

    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_UserCountry' => $id,
            'UserCountry_Name' => Str::title($faker->text(rand(5, 250))),
            'UserCountry_Code' => Str::upper(Util::generateString(3)),
            'UserCountry_PhoneCode' => Util::generateString(4),
            'UserCountry_Img' => Util::generateString(4),
            'UserCountry_Frequent' => $faker->randomElement([1, 2]),
            'UserCountry_FrequentOrder' => 1,
            'UserCountry_Status' => $faker->randomElement([1])
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_user_country_insert` (?,?,?,?,?,?,?)", [
            $object['UserCountry_Name'],
            $object['UserCountry_Code'],
            $object['UserCountry_PhoneCode'],
            $object['UserCountry_Img'],
            $object['UserCountry_Frequent'],
            $object['UserCountry_FrequentOrder'],
            $object['UserCountry_Status']
        ]);
        $object['Id_UserCountry'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TableCreation::user_country];
    }
}
