<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class StatusGroupProviderMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_StatusGroupProvider'            => $id,
            'StatusGroupProvider_Name'          => $faker->text(rand(5, 250)),
            'StatusGroupProvider_Abrv'          => $faker->text(rand(5, 10)),
            'StatusGroupProvider_Color'         => $faker->text(rand(5, 50)),
            'StatusGroupProvider_Status'        => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_status_group_provider_insert` (?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['StatusGroupProvider_Name'],
            $object['StatusGroupProvider_Abrv'],
            $object['StatusGroupProvider_Color'],
            $object['StatusGroupProvider_Status'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_StatusGroupProvider'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear() {
        return [ TC::STATUS_GROUP_PROVIDER ];
    }

}