<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class PackageTourGeneratorMother
{

    public static function push1(
        array $packageTranslAttr = [],
        array $toursTranslList = []
    ) {
        $packageTransl = PackageTranslMother::push1($packageTranslAttr['Id_Package'] ?? null, $packageTranslAttr['Id_Language'] ?? null);
        $packageTransl['PackageRate'] = PackageRateMother::push1($packageTransl['Id_Package']);
        $packageTransl['PackageFee'] = PackageFeeMother::pushFull1($packageTransl['PackageRate']['PackageRate_Price'], $packageTransl['Id_Package'], 0);
        $packageTransl['Tours'] = [];
        foreach ($toursTranslList as $key => $tour) {
            $packageTransl['Tours'][$key] = TourTranslMother::push1(
                idTour: $tour['Id_Tour'] ?? null,
                idLanguage: $tour['Id_Language'] ?? null
            );
            $packageTransl['Tours'][$key]['PackageTour'] = PackageTourMother::push1(
                idPackage: $packageTransl['Id_Package'],
                idTour: $packageTransl['Tours'][$key]['Id_Tour']
            );
            
            if (isset($tour['Equipment'])) {
                $packageTransl['Tours'][$key]['Equipment'] = [];
                foreach ($tour['Equipment'] as $tourEquipment) {
                    $packageTransl['Tours'][$key]['Equipment'][] = PackageTourEquipmentMother::push1(
                        idPackageTour: $packageTransl['Tours'][$key]['PackageTour']['Id_PackageTour'],
                        idEquipment: $tourEquipment['Id_Equipment'] ?? null
                    );
                }
            }

            if (isset($tour['Extra'])) {
                $packageTransl['Tours'][$key]['Extra'] = [];
                foreach ($tour['Extra'] as $tourExtra) {
                    $packageTransl['Tours'][$key]['Extra'][] = PackageTourExtraMother::push1(
                        idPackageTour: $packageTransl['Tours'][$key]['PackageTour']['Id_PackageTour'],
                        idExtra: $tourExtra['Id_Extra'] ?? null
                    );
                }
            }

            if (isset($tour['Upgrade'])) {
                $packageTransl['Tours'][$key]['Upgrade'] = [];
                foreach ($tour['Upgrade'] as $tourUpgrade) {
                    $packageTransl['Tours'][$key]['Upgrade'][] = PackageTourUpgradeMother::push1(
                        idPackageTour: $packageTransl['Tours'][$key]['PackageTour']['Id_PackageTour'],
                        idUpgrade: $tourUpgrade['Id_Upgrade'] ?? null
                    );
                }
            }
        }

        return $packageTransl;
    }
}
