<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadBookingTourPassengerMother
{
    public static function build1($Id_LeadBookingTour, $Id_LeadPassenger, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_LeadBookingTourPassenger' => $id,
            'LeadBookingTourPassenger_Status' => $faker->randomElement([1, 2]),
            'Id_LeadBookingTour' => $Id_LeadBookingTour,
            'Id_LeadPassenger' => $Id_LeadPassenger
        ];
    }

    public static function push1($Id_LeadBookingTour, $Id_LeadPassenger, $id = 1)
    {
        return self::push(self::build1($Id_LeadBookingTour, $Id_LeadPassenger, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_lead_booking_tour_passenger_insert`(?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadBookingTourPassenger_Status'],
            $object['Id_LeadBookingTour'],
            $object['Id_LeadPassenger']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadBookingTourPassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING_TOUR_PASSENGER],
            LeadBookingTourMother::tablesToClear(),
            LeadPassengerMother::tablesToClear(),
        );
    }
}
