<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class HtlTypeRoomBedMother
{
    
    public static function build1($idHtlTypeRoom = null, $idHtlBed = null, $id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_HtlTypeRoomBed' => $id,
            'HtlTypeRoomBed_Status' => $faker->randomElement([1, 2]),
            'Id_HtlTypeRoom' => $idHtlTypeRoom ?? HtlTypeRoomMother::push1()['Id_HtlTypeRoom'],
            'Id_HtlBed' => $idHtlBed ?? HtlBedMother::push1()['Id_HtlBed']
        ];
    }

    public static function push1($idHtlTypeRoom = null, $idHtlBed = null, $id = 0)
    {
        return self::push(self::build1($idHtlTypeRoom, $idHtlBed, $id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_htl_type_room_bed`(`Id_HtlTypeRoomBed`, `HtlTypeRoomBed_Status`, `Id_HtlTypeRoom`, `Id_HtlBed`)
            VALUES (?,?,?,?)", [
            $object['Id_HtlTypeRoomBed'] == 0 ? null : $object['Id_HtlTypeRoomBed'],
            $object['HtlTypeRoomBed_Status'],
            $object['Id_HtlTypeRoom'],
            $object['Id_HtlBed'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_HtlTypeRoomBed'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::HTL_TYPE_ROOM_BED, ...HtlTypeRoomMother::tablesToClear(), ...HtlBedMother::tablesToClear() ];
    }
}
